@extends('layout')
@section('content')
    @include('partials.breadcrumb')

    <!-- we are begin -->
    <div class="we-re">
        <div class="container">
            <div class="row d-flex">
                <div class="col-xl-6 col-lg-6 d-flex align-items-center">
                    <div class="part-text">
                        <div class="section-title">
                            <h2>{{__($basic->about_title)}}</h2>
                            <p>{!! __($basic->about) !!}</p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6">
                    <div class="part-img">
                        <img src="{{asset('assets/images/about-video-image.jpg')}}" alt="..">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- we are end -->

    <!-- video begin-->
    <div class="video">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8 col-lg-8">
                    <div class="section-title">
                        <h2>{{$basic->video_title}}</h2>
                        <p>{{$basic->video_details}}</p>
                    </div>
                </div>
            </div>
            <div class="row justify-content-center">
                <div class="col-xl-6 col-lg-6">
                    <div class="play-video">
                        <a class="play-button venobox mfp-iframe" href="{{$basic->about_video}}"><i class="fas fa-play"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- video end -->

    <!-- about begin -->
    <div class="about">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8 col-lg-8 ">
                    <div class="section-title text-center">
                        <h2>{{$basic->event_h}}</h2>
                        <p>{{$basic->event_p}}</p>
                    </div>
                </div>
            </div>
            <div class="row">
                @foreach($ourEvents as $data)
                <div class="col-xl-6 col-lg-6 col-md-6">
                    <div class="single-about">
                        <div class="heading">
                            <div class="part-icon">
                                {!! $data->icon !!}
                            </div>
                            <div class="part-text">
                                <h3>{{$data->title}}</h3>
                            </div>
                        </div>
                        <p>{{$data->details}}</p>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    <!-- about end -->

    <!-- newsletter begin-->
    <div class="newsletter">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-7 col-lg-7">
                    <div class="section-title text-center">

                        <h2>@lang('Our Newsletter')</h2>
                        <p>@lang('Enter Your Email To Get Update News')</p>
                    </div>
                </div>
            </div>

            <div class="row justify-content-center">
                <div class="col-xl-7 col-lg-7">
                    @include('errors.error')
                    <form class="newsletter-form" action="{{route('subscribe')}}" method="post">
                        @csrf
                        <input type="email" name="email" placeholder="@lang('Enter your email...')" required>
                        <button type="submit">@lang('Subscribe Now')</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- newsletter end -->

    <!-- inventor begin-->
    <div id="investors">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-6 col-lg-6">
                    <div class="section-title text-center">
                        <h2>{{$basic->team_h}}</h2>
                        <p>{{$basic->team_p}}</p>
                    </div>
                </div>
            </div>
            <div class="row">
                @foreach($team as $data)
                <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6">
                    <div class="box mb-lg-5">
                        <div class="image">
                            <img class="img-fluid" src="{{asset('assets/images/our-team/'.$data->image)}}" alt="{{$data->name}}">

                            @if(($data->facebook != null) || ($data->twitter != null) || ($data->linkedin != null) || ($data->pinterest != null))
                                <div class="social_icon">
                                    <ul>
                                        @if($data->facebook != null)
                                        <li>
                                            <a href="{{$data->facebook}}"><i class="fab fa-facebook-f"></i></a>
                                        </li>
                                        @endif

                                        @if($data->twitter != null)
                                        <li>
                                            <a href="{{$data->twitter}}"><i class="fab fa-twitter"></i></a>
                                        </li>
                                        @endif

                                        @if($data->linkedin != null)
                                        <li>
                                            <a href="{{$data->linkedin}}"><i class="fab fa-linkedin"></i></a>
                                        </li>
                                        @endif

                                        @if($data->pinterest != null)
                                        <li>
                                            <a href="{{$data->pinterest}}"><i class="fab fa-pinterest"></i></a>
                                        </li>
                                        @endif
                                    </ul>
                                </div>
                            @endif
                        </div>
                        <div class="info">
                            <h5>{{$data->name}}</h5>
                            <p>{{$data->designation}}</p>
                        </div>
                    </div>
                </div>
                @endforeach


            </div>
        </div>
    </div>
    <!-- inventor end -->


@stop